(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     77929,       1505]
NotebookOptionsPosition[     75258,       1447]
NotebookOutlinePosition[     75653,       1463]
CellTagsIndexPosition[     75610,       1460]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Equidiagonal  kite - Steiner point", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, {
  3.947144439694456*^9, 3.947144443366682*^9}, {3.947339713636549*^9, 
  3.947339717251663*^9}, {3.954728574674156*^9, 3.954728576840864*^9}, {
  3.9547567434027576`*^9, 3.9547567507460346`*^9}, {3.956299395625988*^9, 
  3.956299398221327*^9}, {3.9590505648695316`*^9, 
  3.959050570568201*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about equidiagonal kites in \
the paper \[OpenCurlyDoubleQuote]More Shapes of Central Quadrilaterals\
\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in July \
2025.

This Notebook is Copyright \[Copyright] July 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947148657900776*^9, 3.947148664004244*^9}, {
  3.947339725299139*^9, 3.947339727179648*^9}, {3.954756786770439*^9, 
  3.954756791707377*^9}, {3.9590506175365047`*^9, 3.95905063118071*^9}, {
  3.961413455310493*^9, 
  3.9614134624300947`*^9}},ExpressionUUID->"22c83543-03f0-524a-b077-\
52bf40ea5d06"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"9f6088f9-a2be-3140-964a-\
e41e398b8645"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ptD", "=", 
  RowBox[{"SimetriaAxial", "[", 
   RowBox[{"ptB", ",", "rtCA"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471447897267284`*^9, 3.9471448143356647`*^9}, {3.947339795568245*^9, 
   3.9473398095558796`*^9}, {3.9547552492897663`*^9, 3.954755284434631*^9}, {
   3.956300926380308*^9, 3.956300984737869*^9}, {3.959050651177702*^9, 
   3.959050663529665*^9}},
 CellLabel->
  "In[544]:=",ExpressionUUID->"7895159c-a127-8b44-944b-25ce84d4f88d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ",", 
   RowBox[{"-", 
    SuperscriptBox["b", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947339807338928*^9, 3.947339859159481*^9, 3.947339905318266*^9, 
   3.947339989147003*^9, 3.947376863375458*^9, 3.947377688860035*^9, 
   3.947399223530634*^9, 3.9475699928518295`*^9, 3.954731828747135*^9, 
   3.954755798278473*^9, 3.954757132919309*^9, 3.955530239605236*^9, 
   3.956299221684908*^9, 3.956299272871298*^9, 3.956299429048527*^9, {
   3.956299701653225*^9, 3.956299703903105*^9}, {3.956300971386219*^9, 
   3.956300986200109*^9}, 3.9563039162599144`*^9, 3.959043895161728*^9, 
   3.95904455978323*^9, 3.959050667646977*^9, 3.959051296564237*^9, 
   3.9599173455571427`*^9, 3.961150415479515*^9, 3.961413475859359*^9},
 CellLabel->
  "Out[546]=",ExpressionUUID->"fb84bf75-8277-4b06-9670-d02d79f10380"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "if", " ", "ABCD", " ", "is", " ", "an", " ", "equidiagonal", " ", "kite",
      " ", "we", " ", 
     RowBox[{"have", ":", " ", "S"}]}], "=", 
    RowBox[{
     RowBox[{"2", "[", "ABC", "]"}], "=", 
     RowBox[{
      RowBox[{"[", "ABCD", "]"}], "=", " ", 
      RowBox[{
       RowBox[{"AC", "*", 
        RowBox[{"BD", "/", "2"}]}], "=", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "/", "2"}]}]}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"equidiag", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Numerator", "[", 
       RowBox[{"Factor", "[", 
        RowBox[{
         RowBox[{"CuadradoDistancia", "[", 
          RowBox[{"ptB", ",", "ptD"}], "]"}], "-", 
         RowBox[{"CuadradoDistancia", "[", 
          RowBox[{"ptA", ",", "ptC"}], "]"}]}], "]"}], "]"}], "==", "0"}], "&&", 
     RowBox[{"S", "==", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "/", "2"}]}]}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.959918206327215*^9, 3.95991825474979*^9}, {
  3.961151041398266*^9, 3.961151052565998*^9}, {3.9611510955153885`*^9, 
  3.9611512032851944`*^9}},
 CellLabel->
  "In[547]:=",ExpressionUUID->"65dd2912-a8b2-a446-a65d-7d6c98b927d0"]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-\
8944aef04ea5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "central", " ", "quadrilateral", " ", "of", " ", "ABCD", " ", "wrt", " ", 
     "a", " ", "point", " ", "E"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"n_Integer", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{
           RowBox[{"ETC", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "]"}], 
        "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX_", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rectangleQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P1_", ",", "P2_", ",", "P3_", ",", "P4_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{"And", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{"SonParalelas", "[", 
          RowBox[{
           RowBox[{"Recta", "[", 
            RowBox[{"P1", ",", "P2"}], "]"}], ",", 
           RowBox[{"Recta", "[", 
            RowBox[{"P3", ",", "P4"}], "]"}]}], "]"}], ",", "cond"}], "]"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{"SonParalelas", "[", 
          RowBox[{
           RowBox[{"Recta", "[", 
            RowBox[{"P1", ",", "P4"}], "]"}], ",", 
           RowBox[{"Recta", "[", 
            RowBox[{"P2", ",", "P3"}], "]"}]}], "]"}], ",", "cond"}], "]"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{"SonPerpendiculares", "[", 
          RowBox[{
           RowBox[{"Recta", "[", 
            RowBox[{"P1", ",", "P2"}], "]"}], ",", 
           RowBox[{"Recta", "[", 
            RowBox[{"P2", ",", "P3"}], "]"}]}], "]"}], ",", "cond"}], "]"}]}],
       "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.954755422028537*^9, 3.954755444302299*^9}, {
   3.954755510189615*^9, 3.9547556654655304`*^9}, {3.954756246303211*^9, 
   3.954756258310093*^9}, {3.954756539544531*^9, 3.954756557385113*^9}, {
   3.954756592197891*^9, 3.954756630631082*^9}, {3.954756965437847*^9, 
   3.954756984534746*^9}, {3.9547570451409245`*^9, 3.9547570732294483`*^9}, {
   3.9547571716004887`*^9, 3.9547571856117535`*^9}, {3.9547572771795826`*^9, 
   3.954757312322375*^9}, {3.95475745528866*^9, 3.954757469730625*^9}, {
   3.954757619426098*^9, 3.9547576217454853`*^9}, 3.954757823439115*^9, {
   3.954758024281746*^9, 3.954758036096319*^9}, 3.9547580746525097`*^9, {
   3.9547582109077053`*^9, 3.954758249530725*^9}, {3.956299197234873*^9, 
   3.9562992014433975`*^9}, {3.956302404396764*^9, 3.956302474075535*^9}, {
   3.9563041601630363`*^9, 3.956304170018783*^9}, 3.956304207307005*^9, {
   3.9590509389679947`*^9, 3.9590509608952236`*^9}, {3.961150427519331*^9, 
   3.961150445594778*^9}, 3.961413468871181*^9},
 CellLabel->
  "In[548]:=",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 3.946441726397751*^9}, {3.956137230525439*^9, 
  3.956137236030091*^9}, {3.956137322420559*^9, 3.956137323751978*^9}, {
  3.9561374910757213`*^9, 
  3.956137494516241*^9}},ExpressionUUID->"3cbb4941-f491-e944-a1fa-\
7bd4c19f5af3"],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3V9sE1fCP3zrfW9+F3PxyyUXSLyKLOUCqaqiSC+oqpyLoKJICWoVRVBk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    "], {{0, 136.52830188679243`}, {671.0943396226414, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{671.0943396226414, 136.52830188679243`},
  PlotRange->{{0, 671.0943396226414}, {0, 136.52830188679243`}}]], "Input",
 CellChangeTimes->{3.956137328142054*^9, 3.956137472932368*^9, 
  3.9562965472861385`*^9, 3.959050782007242*^9},
 CellLabel->
  "In[555]:=",ExpressionUUID->"a44dd8ce-716c-ff47-b686-3d356d61de25"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3V9sE1fCP3zrfW9+F3PxyyUXSLyKLOUCqaqiSC+oqpyLoKJICWoVRVBk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    "], {{0, 136.52830188679243`}, {671.0943396226414, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{671.0943396226414, 136.52830188679243`},
  PlotRange->{{0, 671.0943396226414}, {0, 136.52830188679243`}}]], "Output",
 CellChangeTimes->{3.961413475962987*^9},
 CellLabel->
  "Out[555]=",ExpressionUUID->"f0657259-111a-4bb0-9cd9-8c2beeeab89d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "The", " ", "Steiner", " ", "point", " ", "of", " ", "an", " ", 
    "orthodiagonal", " ", "quadrilateral", " ", "coincides", " ", "with", " ",
     "the", " ", "point", " ", "of", " ", "intersection", " ", "of", " ", 
    "the", " ", "perpendicular", " ", "bisectors", " ", "of", " ", "the", " ",
     "diagonals", " ", 
    RowBox[{"(", 
     RowBox[{"Proposition", " ", "7.9"}], ")"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"ptE", "=", 
   RowBox[{"Medio", "[", 
    RowBox[{"ptC", ",", "ptA"}], " ", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.954729517411064*^9, 3.954729545606804*^9}, {
   3.954745534742643*^9, 3.954745542313005*^9}, {3.954756841827467*^9, 
   3.954756852715332*^9}, {3.955504132039633*^9, 3.955504186320764*^9}, {
   3.955504219539226*^9, 3.955504248205105*^9}, {3.956301695357956*^9, 
   3.9563017003307*^9}, {3.956301764956686*^9, 3.956301815498993*^9}, 
   3.956304835816866*^9, {3.959050685618236*^9, 3.959050694930555*^9}, {
   3.9590507250577965`*^9, 3.959050730288049*^9}, {3.961150326058481*^9, 
   3.9611503473727016`*^9}},
 CellLabel->
  "In[556]:=",ExpressionUUID->"24c0694c-7ce6-5a4a-a7ef-49ffd3a8021d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{
  3.9555041874351273`*^9, {3.955504223393198*^9, 3.955504249151425*^9}, 
   3.95553154641428*^9, {3.9555316614930115`*^9, 3.955531670467825*^9}, {
   3.9561278641423454`*^9, 3.956127874804348*^9}, 3.9562967626592865`*^9, 
   3.956301662315485*^9, 3.956301701676415*^9, 3.956301766727982*^9, 
   3.9563018172858562`*^9, 3.956302076039715*^9, 3.956303938440157*^9, 
   3.9590438953727303`*^9, 3.9590445598272743`*^9, 3.9590448352716427`*^9, 
   3.9590507311371326`*^9, 3.959051296580244*^9, 3.959917345576115*^9, 
   3.961150459567421*^9, 3.961413475977817*^9},
 CellLabel->
  "Out[556]=",ExpressionUUID->"d13f289f-8e24-4226-94a5-937b38ba47e9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FGHI  square ", "Section",
 CellChangeTimes->{{3.959043975817276*^9, 
  3.95904398797558*^9}},ExpressionUUID->"533a37db-4bf4-c049-b2cf-\
748105802c1b"],

Cell["Proved sinthetically (Theorem 7.22)", "Text",
 CellChangeTimes->{{3.9590439954835434`*^9, 3.959044041168476*^9}, {
  3.959044151810156*^9, 3.9590444167704334`*^9}, {3.95904446076993*^9, 
  3.9590444797297*^9}, {3.9590507957138777`*^9, 3.959050804751854*^9}, {
  3.9611501802757244`*^9, 
  3.961150189715332*^9}},ExpressionUUID->"e4f23084-35ad-8447-a2e8-\
950e78b432d0"]
}, Closed]],

Cell[CellGroupData[{

Cell["FGHI  rectangle", "Section",
 CellChangeTimes->{{3.959043975817276*^9, 3.95904398797558*^9}, {
  3.959044494170885*^9, 3.959044501522095*^9}, {3.9590508304054775`*^9, 
  3.9590508355792217`*^9}},ExpressionUUID->"38350a6d-5fe1-314f-b6b7-\
2ebc74453d7a"],

Cell[CellGroupData[{

Cell["X (586)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.9562967058828487`*^9, 
   3.9562967090935974`*^9}, {3.959047784597421*^9, 3.959047785429079*^9}, 
   3.959048035949947*^9, {3.9590508402971745`*^9, 3.959050842572043*^9}, 
   3.9590511866565266`*^9, 
   3.9611510729958687`*^9},ExpressionUUID->"968e4dfa-298c-0548-91fc-\
0a1085d64484"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X586", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{"ETC", "[", 
    RowBox[{"[", 
     RowBox[{"586", ",", "2"}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.959917357846834*^9, 3.959917387908682*^9}, {
   3.959919547896864*^9, 3.9599195540181646`*^9}, 3.959921775625294*^9, {
   3.961150466732006*^9, 3.9611504694930058`*^9}},
 CellLabel->
  "In[557]:=",ExpressionUUID->"3c3172ad-4663-e74b-af8f-a1c035c1b29f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", "c"}], "-", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "c"}], "-", "S"}], ")"}]}], "-", 
    RowBox[{"b", " ", "c", " ", "S"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], " ", "b", " ", "c"}], "+", 
    RowBox[{"b", " ", "c", " ", "S"}], "+", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "-", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "c"}], "+", "S"}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], " ", "b", " ", "c"}], "+", 
    RowBox[{"b", " ", "c", " ", "S"}], "-", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "-", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "c"}], "+", "S"}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.959917366869383*^9, 3.959917388565539*^9}, 
   3.959919554939184*^9, 3.9599217767288036`*^9, 3.9611504781834393`*^9, 
   3.961151060355488*^9, 3.961413476008731*^9},
 CellLabel->
  "Out[557]=",ExpressionUUID->"c0a5dd5e-4a73-4d8a-9ebf-18a265ed860a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X586", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rectangleQuadQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], ",", 
   "equidiag"}], "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.956296781016487*^9, 3.956296864013699*^9}, {
  3.956298333129472*^9, 3.95629835806628*^9}, {3.956301834082149*^9, 
  3.956301837011614*^9}, {3.959047791999655*^9, 3.959047792806225*^9}, {
  3.959047824992449*^9, 3.959047870766885*^9}, {3.959050853066341*^9, 
  3.959050859745323*^9}, {3.959050977757351*^9, 3.9590510610343*^9}, {
  3.959917396181785*^9, 3.959917397549568*^9}, {3.959917557934225*^9, 
  3.959917571075508*^9}, {3.959917605388794*^9, 3.959917610684637*^9}, {
  3.959921790098137*^9, 3.959921796905031*^9}, {3.9611504889066505`*^9, 
  3.961150491997711*^9}, {3.9611505380287113`*^9, 3.9611505417375183`*^9}},
 CellLabel->
  "In[558]:=",ExpressionUUID->"a4829d35-84c3-134d-ba66-c2162bdf8abc"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.959051011859461*^9, 3.9590510520697975`*^9}, 
   3.95905118361325*^9, 3.9590513111664505`*^9, 3.9599174033355503`*^9, {
   3.9599175709005985`*^9, 3.959917574955551*^9}, 3.959917614481495*^9, 
   3.959921801096321*^9, 3.9611504991066933`*^9, 3.9611505451389084`*^9, 
   3.961151062098564*^9, 3.961413482444538*^9},
 CellLabel->
  "Out[559]=",ExpressionUUID->"103f8327-a79e-4ce8-97dc-66518873cd21"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1294, 655},
WindowMargins->{{254, Automatic}, {Automatic, 1}},
FrontEndVersion->"14.2 for Mac OS X x86 (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"db4dd2d1-c25b-f845-bf74-4284b46e47e3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 471, 7, 96, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[1054, 31, 1520, 26, 164, "Text",ExpressionUUID->"22c83543-03f0-524a-b077-52bf40ea5d06"],
Cell[CellGroupData[{
Cell[2599, 61, 200, 4, 66, "Section",ExpressionUUID->"9f6088f9-a2be-3140-964a-e41e398b8645"],
Cell[CellGroupData[{
Cell[2824, 69, 1551, 32, 70, "Input",ExpressionUUID->"7895159c-a127-8b44-944b-25ce84d4f88d"],
Cell[4378, 103, 1114, 25, 35, "Output",ExpressionUUID->"fb84bf75-8277-4b06-9670-d02d79f10380"]
}, Open  ]],
Cell[5507, 131, 1255, 36, 49, "Input",ExpressionUUID->"65dd2912-a8b2-a446-a65d-7d6c98b927d0"]
}, Closed]],
Cell[CellGroupData[{
Cell[6799, 172, 255, 4, 52, "Section",ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-8944aef04ea5"],
Cell[7057, 178, 6801, 178, 360, "Input",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],
Cell[CellGroupData[{
Cell[13895, 361, 356, 6, 52, "Section",ExpressionUUID->"3cbb4941-f491-e944-a1fa-7bd4c19f5af3"],
Cell[CellGroupData[{
Cell[14276, 371, 26982, 447, 149, "Input",ExpressionUUID->"a44dd8ce-716c-ff47-b686-3d356d61de25"],
Cell[41261, 820, 26855, 444, 153, "Output",ExpressionUUID->"f0657259-111a-4bb0-9cd9-8c2beeeab89d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68153, 1269, 1204, 24, 70, "Input",ExpressionUUID->"24c0694c-7ce6-5a4a-a7ef-49ffd3a8021d"],
Cell[69360, 1295, 746, 13, 33, "Output",ExpressionUUID->"d13f289f-8e24-4226-94a5-937b38ba47e9"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70155, 1314, 157, 3, 66, "Section",ExpressionUUID->"533a37db-4bf4-c049-b2cf-748105802c1b"],
Cell[70315, 1319, 375, 6, 31, "Text",ExpressionUUID->"e4f23084-35ad-8447-a2e8-950e78b432d0"]
}, Closed]],
Cell[CellGroupData[{
Cell[70727, 1330, 258, 4, 52, "Section",ExpressionUUID->"38350a6d-5fe1-314f-b6b7-2ebc74453d7a"],
Cell[CellGroupData[{
Cell[71010, 1338, 653, 10, 53, "Subsection",ExpressionUUID->"968e4dfa-298c-0548-91fc-0a1085d64484"],
Cell[CellGroupData[{
Cell[71688, 1352, 449, 10, 29, "Input",ExpressionUUID->"3c3172ad-4663-e74b-af8f-a1c035c1b29f"],
Cell[72140, 1364, 1298, 39, 35, "Output",ExpressionUUID->"c0a5dd5e-4a73-4d8a-9ebf-18a265ed860a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73475, 1408, 1277, 24, 49, "Input",ExpressionUUID->"a4829d35-84c3-134d-ba66-c2162bdf8abc"],
Cell[74755, 1434, 451, 7, 33, "Output",ExpressionUUID->"103f8327-a79e-4ce8-97dc-66518873cd21"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

